/*
 * Decompiled with CFR 0.152.
 */
package jace.tracker;

import jace.hardware.mockingboard.Card;
import jace.tracker.PlaybackEngine;
import jace.tracker.Song;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import javax.sound.sampled.LineUnavailableException;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableModel;

public class TrackerUI
extends JFrame {
    PlaybackEngine engine;
    Card chip;
    long songSpeed = 100L;
    Thread performerThread;
    int playbackSequence = 0;
    int playbackPattern = 0;
    int viewPattern = 0;
    int playbackRow = 0;
    public static Integer[] envelopeShapeValues = new Integer[]{null, 13, 1, 7, 11, 14, 10, 12, 8};
    private JLabel bpmLabel;
    private JButton clonePatternButton;
    private JButton deletePatternButton;
    private JComboBox envelopeComboBox;
    private JPanel infoTab;
    private JPanel mainPanel;
    private JButton newPatternButton;
    private JToggleButton patternFollowButton;
    private JLabel patternLabel;
    private JComboBox patternSelect;
    private JScrollPane patternViewScroll;
    private JPanel patternViewTab;
    private JTable patternViewTable;
    private JToggleButton playButton;
    private JLabel playerInfoLabel;
    private JScrollPane sequenceViewScroll;
    private JPanel sequenceViewTab;
    private JTable sequenceViewTable;
    private JTextField songAuthorField;
    private JLabel songAuthorLabel;
    private JTextArea songCommentsField;
    private JLabel songCommentsLabel;
    private JTextField songNameField;
    private JLabel songNameLabel;
    private JLabel songSequenceLabel;
    private JLabel songSettingsLabel;
    private JTextField songSpeedField;
    private JLabel speedLabel;
    private JTabbedPane tabPane;

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new TrackerUI().setVisible(true);
            }
        });
    }

    public TrackerUI() {
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (InstantiationException ex) {
            ex.printStackTrace();
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
        }
        catch (UnsupportedLookAndFeelException ex) {
            ex.printStackTrace();
        }
        this.chip = new Card();
        this.engine = new PlaybackEngine(this.chip);
        this.initComponents();
    }

    private void initComponents() {
        this.envelopeComboBox = new JComboBox();
        this.mainPanel = new JPanel();
        this.tabPane = new JTabbedPane();
        this.patternViewTab = new JPanel();
        this.patternLabel = new JLabel();
        this.patternSelect = new JComboBox();
        this.patternViewScroll = new JScrollPane();
        this.patternViewTable = new JTable();
        this.newPatternButton = new JButton();
        this.clonePatternButton = new JButton();
        this.deletePatternButton = new JButton();
        this.patternFollowButton = new JToggleButton();
        this.sequenceViewTab = new JPanel();
        this.sequenceViewScroll = new JScrollPane();
        this.sequenceViewTable = new JTable();
        this.songSequenceLabel = new JLabel();
        this.songSettingsLabel = new JLabel();
        this.songNameLabel = new JLabel();
        this.songAuthorLabel = new JLabel();
        this.songCommentsLabel = new JLabel();
        this.speedLabel = new JLabel();
        this.songNameField = new JTextField();
        this.songAuthorField = new JTextField();
        this.songSpeedField = new JTextField();
        this.bpmLabel = new JLabel();
        this.songCommentsField = new JTextArea();
        this.infoTab = new JPanel();
        this.playButton = new JToggleButton();
        this.playerInfoLabel = new JLabel();
        this.envelopeComboBox.setMaximumRowCount(9);
        this.envelopeComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{" ", "/\u00af\u00af\u00af\u00af\u00af", "\\_____", "/|_____", "\\|\u00af\u00af\u00af\u00af\u00af", "/\\/\\/\\/\\/\\/\\", "\\/\\/\\/\\/\\/\\/", "/|/|/|/|/|/|", "\\|\\|\\|\\|\\|\\|"}));
        this.envelopeComboBox.setMinimumSize(new Dimension(84, 30));
        this.setDefaultCloseOperation(3);
        this.setTitle("Woz Tracker");
        this.setCursor(new Cursor(0));
        this.setName("trackerFrame");
        this.tabPane.setBackground(SystemColor.window);
        this.patternViewTab.setBackground(SystemColor.window);
        this.patternLabel.setText("Pattern:");
        this.patternSelect.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.patternSelect.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                TrackerUI.this.patternSelectPropertyChange(evt);
            }
        });
        this.patternViewScroll.setBackground(SystemColor.controlShadow);
        this.patternViewScroll.setAutoscrolls(true);
        this.patternViewScroll.setFocusable(false);
        this.patternViewTable.setModel(new DefaultTableModel(new Object[][]{{new Integer(1), null, null, null, null, null, null, null, null, null, null}, {new Integer(2), null, null, null, null, null, null, null, null, null, null}, {new Integer(3), null, null, null, null, null, null, null, null, null, null}, {new Integer(4), null, null, null, null, null, null, null, null, null, null}, {new Integer(5), null, null, null, null, null, null, null, null, null, null}, {new Integer(6), null, null, null, null, null, null, null, null, null, null}, {new Integer(7), null, null, null, null, null, null, null, null, null, null}, {new Integer(8), null, null, null, null, null, null, null, null, null, null}, {new Integer(9), null, null, null, null, null, null, null, null, null, null}, {new Integer(10), null, null, null, null, null, null, null, null, null, null}, {new Integer(11), null, null, null, null, null, null, null, null, null, null}, {new Integer(12), null, null, null, null, null, null, null, null, null, null}, {new Integer(13), null, null, null, null, null, null, null, null, null, null}, {new Integer(14), null, null, null, null, null, null, null, null, null, null}, {new Integer(15), null, null, null, null, null, null, null, null, null, null}, {new Integer(16), null, null, null, null, null, null, null, null, null, null}, {new Integer(17), null, null, null, null, null, null, null, null, null, null}, {new Integer(18), null, null, null, null, null, null, null, null, null, null}, {new Integer(19), null, null, null, null, null, null, null, null, null, null}, {new Integer(20), null, null, null, null, null, null, null, null, null, null}, {new Integer(21), null, null, null, null, null, null, null, null, null, null}, {new Integer(22), null, null, null, null, null, null, null, null, null, null}, {new Integer(23), null, null, null, null, null, null, null, null, null, null}, {new Integer(24), null, null, null, null, null, null, null, null, null, null}, {new Integer(25), null, null, null, null, null, null, null, null, null, null}, {new Integer(26), null, null, null, null, null, null, null, null, null, null}, {new Integer(27), null, null, null, null, null, null, null, null, null, null}, {new Integer(28), null, null, null, null, null, null, null, null, null, null}, {new Integer(29), null, null, null, null, null, null, null, null, null, null}, {new Integer(30), null, null, null, null, null, null, null, null, null, null}, {new Integer(31), null, null, null, null, null, null, null, null, null, null}, {new Integer(32), null, null, null, null, null, null, null, null, null, null}}, new String[]{"#", "Enable", "Note A", "Amp A", "Note B", "Amp B", "Note C", "Amp C", "E. Shp", "E. Per", "N. Per"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{Integer.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class};
                this.canEdit = new boolean[]{false, true, true, true, true, true, true, true, true, true, true};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.patternViewTable.setColumnSelectionAllowed(true);
        this.configurePatternTableColumns();
        this.patternViewTable.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                TrackerUI.this.patternViewTablePropertyChange(evt);
            }
        });
        this.patternViewScroll.setViewportView(this.patternViewTable);
        this.newPatternButton.setText("New");
        this.newPatternButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                TrackerUI.this.newPatternButtonMouseClicked(evt);
            }
        });
        this.clonePatternButton.setText("Clone");
        this.clonePatternButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                TrackerUI.this.clonePatternButtonMouseClicked(evt);
            }
        });
        this.deletePatternButton.setText("Delete");
        this.deletePatternButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                TrackerUI.this.deletePatternButtonMouseClicked(evt);
            }
        });
        this.patternFollowButton.setText("Follow Playback");
        GroupLayout patternViewTabLayout = new GroupLayout(this.patternViewTab);
        this.patternViewTab.setLayout(patternViewTabLayout);
        patternViewTabLayout.setHorizontalGroup(patternViewTabLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(patternViewTabLayout.createSequentialGroup().addContainerGap().addGroup(patternViewTabLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.patternViewScroll, -1, 810, Short.MAX_VALUE).addGroup(patternViewTabLayout.createSequentialGroup().addComponent(this.patternLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.patternSelect, -2, 70, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.newPatternButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.clonePatternButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.deletePatternButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 396, Short.MAX_VALUE).addComponent(this.patternFollowButton))).addContainerGap()));
        patternViewTabLayout.setVerticalGroup(patternViewTabLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(patternViewTabLayout.createSequentialGroup().addGroup(patternViewTabLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.patternSelect, -2, -1, -2).addComponent(this.patternLabel).addComponent(this.deletePatternButton).addComponent(this.clonePatternButton).addComponent(this.newPatternButton).addComponent(this.patternFollowButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.patternViewScroll, -1, 346, Short.MAX_VALUE).addContainerGap()));
        this.tabPane.addTab("Pattern", this.patternViewTab);
        this.sequenceViewTab.setBackground(SystemColor.window);
        this.sequenceViewScroll.setBackground(SystemColor.controlShadow);
        this.sequenceViewScroll.setOpaque(false);
        this.sequenceViewTable.setModel(new DefaultTableModel(new Object[][]{{new Integer(1), null, null}, {new Integer(2), null, null}, {new Integer(3), null, null}, {new Integer(4), null, null}, {new Integer(5), null, null}, {new Integer(6), null, null}, {new Integer(7), null, null}, {new Integer(8), null, null}, {new Integer(9), null, null}, {new Integer(10), null, null}, {new Integer(11), null, null}, {new Integer(12), null, null}, {new Integer(13), null, null}, {new Integer(14), null, null}, {new Integer(15), null, null}, {new Integer(16), null, null}, {new Integer(17), null, null}, {new Integer(18), null, null}, {new Integer(19), null, null}, {new Integer(20), null, null}, {new Integer(21), null, null}, {new Integer(22), null, null}, {new Integer(23), null, null}, {new Integer(24), null, null}, {new Integer(25), null, null}, {new Integer(26), null, null}, {new Integer(27), null, null}, {new Integer(28), null, null}, {new Integer(29), null, null}, {new Integer(30), null, null}, {new Integer(31), null, null}, {new Integer(32), null, null}}, new String[]{"#", "L Pat", "R Pat"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{Integer.class, Integer.class, Integer.class};
                this.canEdit = new boolean[]{false, true, true};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.sequenceViewTable.setAutoResizeMode(0);
        this.configureSequenceTableColumns();
        this.sequenceViewTable.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                TrackerUI.this.sequenceViewTablePropertyChange(evt);
            }
        });
        this.sequenceViewScroll.setViewportView(this.sequenceViewTable);
        this.songSequenceLabel.setText("Song Sequence:");
        this.songSettingsLabel.setText("Song Settings:");
        this.songNameLabel.setText("Name:");
        this.songAuthorLabel.setText("Author:");
        this.songCommentsLabel.setText("Comments:");
        this.speedLabel.setText("Speed:");
        this.songNameField.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                TrackerUI.this.songNameFieldPropertyChange(evt);
            }
        });
        this.songAuthorField.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                TrackerUI.this.songAuthorFieldPropertyChange(evt);
            }
        });
        this.songSpeedField.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                TrackerUI.this.songSpeedFieldPropertyChange(evt);
            }
        });
        this.bpmLabel.setText("BPM");
        this.songCommentsField.setColumns(20);
        this.songCommentsField.setRows(5);
        this.songCommentsField.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.songCommentsField.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                TrackerUI.this.songCommentsFieldPropertyChange(evt);
            }
        });
        GroupLayout sequenceViewTabLayout = new GroupLayout(this.sequenceViewTab);
        this.sequenceViewTab.setLayout(sequenceViewTabLayout);
        sequenceViewTabLayout.setHorizontalGroup(sequenceViewTabLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(sequenceViewTabLayout.createSequentialGroup().addContainerGap().addGroup(sequenceViewTabLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.songSequenceLabel).addComponent(this.sequenceViewScroll, -1, 152, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(sequenceViewTabLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(sequenceViewTabLayout.createSequentialGroup().addComponent(this.songCommentsLabel).addGap(335, 335, 335)).addGroup(sequenceViewTabLayout.createSequentialGroup().addGroup(sequenceViewTabLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.songSettingsLabel).addGroup(sequenceViewTabLayout.createSequentialGroup().addGroup(sequenceViewTabLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.songNameLabel).addComponent(this.songAuthorLabel)).addGap(38, 38, 38).addGroup(sequenceViewTabLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.songNameField, -1, 286, Short.MAX_VALUE).addComponent(this.songAuthorField, -1, 286, Short.MAX_VALUE).addGroup(sequenceViewTabLayout.createSequentialGroup().addComponent(this.songSpeedField, -2, 59, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bpmLabel)).addComponent(this.songCommentsField, -2, 234, -2)))).addGap(29, 29, 29)).addGroup(sequenceViewTabLayout.createSequentialGroup().addComponent(this.speedLabel).addGap(353, 353, 353))).addGap(274, 274, 274)));
        sequenceViewTabLayout.setVerticalGroup(sequenceViewTabLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(sequenceViewTabLayout.createSequentialGroup().addContainerGap().addGroup(sequenceViewTabLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.songSequenceLabel).addComponent(this.songSettingsLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(sequenceViewTabLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(sequenceViewTabLayout.createSequentialGroup().addGroup(sequenceViewTabLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.songNameLabel).addComponent(this.songNameField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(sequenceViewTabLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.songAuthorField, -2, -1, -2).addComponent(this.songAuthorLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(sequenceViewTabLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.speedLabel, -2, 14, -2).addGroup(sequenceViewTabLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.songSpeedField, -2, -1, -2).addComponent(this.bpmLabel))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(sequenceViewTabLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.songCommentsField, -2, 137, -2).addComponent(this.songCommentsLabel))).addComponent(this.sequenceViewScroll, -1, 344, Short.MAX_VALUE)).addContainerGap()));
        this.tabPane.addTab("Sequence", this.sequenceViewTab);
        this.infoTab.setBackground(SystemColor.window);
        GroupLayout infoTabLayout = new GroupLayout(this.infoTab);
        this.infoTab.setLayout(infoTabLayout);
        infoTabLayout.setHorizontalGroup(infoTabLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 830, Short.MAX_VALUE));
        infoTabLayout.setVerticalGroup(infoTabLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 386, Short.MAX_VALUE));
        this.tabPane.addTab("Info", this.infoTab);
        this.playButton.setText("Play");
        this.playButton.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                TrackerUI.this.playButtonStateChanged(evt);
            }
        });
        this.playerInfoLabel.setText("Info goes here");
        GroupLayout mainPanelLayout = new GroupLayout(this.mainPanel);
        this.mainPanel.setLayout(mainPanelLayout);
        mainPanelLayout.setHorizontalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addContainerGap().addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tabPane).addGroup(mainPanelLayout.createSequentialGroup().addComponent(this.playButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.playerInfoLabel, -1, 778, Short.MAX_VALUE))).addContainerGap()));
        mainPanelLayout.setVerticalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addContainerGap().addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.playButton).addComponent(this.playerInfoLabel)).addGap(11, 11, 11).addComponent(this.tabPane, -1, 414, Short.MAX_VALUE).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.mainPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.mainPanel, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void playButtonStateChanged(ChangeEvent evt) {
        if (this.playButton.isSelected()) {
            this.startPlayback();
        } else {
            this.stopPlayback();
        }
    }

    private void songCommentsFieldPropertyChange(PropertyChangeEvent evt) {
    }

    private void songSpeedFieldPropertyChange(PropertyChangeEvent evt) {
    }

    private void songAuthorFieldPropertyChange(PropertyChangeEvent evt) {
    }

    private void songNameFieldPropertyChange(PropertyChangeEvent evt) {
    }

    private void sequenceViewTablePropertyChange(PropertyChangeEvent evt) {
    }

    private void patternViewTablePropertyChange(PropertyChangeEvent evt) {
    }

    private void deletePatternButtonMouseClicked(MouseEvent evt) {
    }

    private void clonePatternButtonMouseClicked(MouseEvent evt) {
    }

    private void patternSelectPropertyChange(PropertyChangeEvent evt) {
    }

    private void newPatternButtonMouseClicked(MouseEvent evt) {
    }

    public void startPlayback() {
        this.playButton.setText("Stop");
        try {
            this.engine.startPlayback();
        }
        catch (LineUnavailableException ex) {
            ex.printStackTrace();
        }
        if (this.performerThread == null || !this.performerThread.isAlive()) {
            this.performerThread = new Thread(){

                public void run() {
                    while (TrackerUI.this.playButton.isSelected()) {
                        TrackerUI.this.playRow();
                    }
                }
            };
            this.performerThread.start();
        }
    }

    public void stopPlayback() {
        if (this.performerThread != null) {
            try {
                while (this.performerThread.isAlive()) {
                    Thread.sleep(10L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.performerThread = null;
        this.playButton.setText("Play");
        this.playerInfoLabel.setText("Stopped.");
        this.engine.stopPlayback();
    }

    public void playRow() {
        this.playRowDisplay();
        this.playRowSound();
        ++this.playbackRow;
        if (this.playbackRow >= 32) {
            this.playbackRow = 0;
        }
        try {
            Thread.sleep(this.songSpeed);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void playRowSound() {
        Map<Card.Reg, Integer> row = Song.translateRow(this.patternViewTable, this.playbackRow);
        for (Card.Reg key : Card.Reg.preferredOrder) {
            if (row.get((Object)key) == null) continue;
            this.chip.writeReg(0, key, (int)row.get((Object)key));
            this.chip.writeReg(1, key, (int)row.get((Object)key));
        }
    }

    public void playRowDisplay() {
        this.playerInfoLabel.setText("Playing row " + (this.playbackRow + 1));
        if (this.viewPattern == this.playbackPattern) {
            this.patternViewTable.getModel().setValueAt(">" + (this.playbackRow + 1), this.playbackRow, 0);
            if (this.playbackRow == 0) {
                this.patternViewTable.getModel().setValueAt("32", 31, 0);
            } else {
                this.patternViewTable.getModel().setValueAt(this.playbackRow, this.playbackRow - 1, 0);
            }
        }
        if (this.patternFollowButton.isSelected()) {
            int viewportHeight = this.patternViewScroll.getViewport().getHeight();
            int middle = (viewportHeight - viewportHeight % this.patternViewTable.getRowHeight()) / 2;
            int newPos = Math.max(0, this.playbackRow * this.patternViewTable.getRowHeight() - middle);
            newPos = Math.min(this.patternViewTable.getHeight() - viewportHeight, newPos);
            newPos = Math.max(0, newPos);
            this.patternViewScroll.getViewport().setViewPosition(new Point(0, newPos));
        }
        this.repaint();
    }

    private void configurePatternTableColumns() {
        this.patternViewTable.getColumnModel().getColumn(0).setMaxWidth(30);
        this.patternViewTable.getColumnModel().getColumn(3).setMaxWidth(40);
        this.patternViewTable.getColumnModel().getColumn(5).setMaxWidth(40);
        this.patternViewTable.getColumnModel().getColumn(7).setMaxWidth(40);
        this.patternViewTable.getColumnModel().getColumn(8).setCellEditor(new DefaultCellEditor(this.envelopeComboBox));
    }

    private void configureSequenceTableColumns() {
        this.sequenceViewTable.getColumnModel().getColumn(0).setMaxWidth(30);
        this.sequenceViewTable.getColumnModel().getColumn(1).setMaxWidth(55);
    }
}

